#include <stdio.h>

#include <d3d11.h>
#include <dxgi1_2.h>

#include "IUnityInterface.h"
#include "IUnityGraphics.h"
#include "IUnityGraphicsD3D11.h"

#pragma comment(lib, "dxgi.lib")

namespace
{
	IUnityInterfaces*       g_unity = nullptr;
}


void logMessage(const char* s)
{
	const char* path = "s:\\unity_plugin_log.txt";
	FILE *f;
	fopen_s(&f, path , "at");
	if (!f) fopen_s(&f, path, "wt");
	fprintf(f, "Log: %s\n", s);
	fclose(f);	
}

extern "C"
{
	UNITY_INTERFACE_EXPORT void UNITY_INTERFACE_API UnityPluginLoad(IUnityInterfaces* unityInterfaces)
	{
		g_unity = unityInterfaces;
		
		logMessage("Load");
	}

	UNITY_INTERFACE_EXPORT void UNITY_INTERFACE_API UnityPluginUnload()
	{
		logMessage("Unload");
	}	

	UNITY_INTERFACE_EXPORT void UNITY_INTERFACE_API MyTest()
	{
		logMessage("Test");
	}
}